/*
 * Decompiled with CFR 0.152.
 */
package lu.fisch.ixui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.Set;

public class Ini {
    private static String dirname = "";
    private static String ininame = "ixui.ini";
    private static String filename = "";
    private static File dir = new File(dirname);
    private static File file = new File(filename);
    private static Properties p = new Properties();
    private static Ini ini = null;

    public static String getDirname() {
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
            return System.getProperty("user.home") + "/Library/Application Support/Ixui";
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            String appData = System.getenv("APPDATA");
            if (appData != null && !appData.equals("")) {
                return appData + "\\Ixui";
            }
            return System.getProperty("user.home") + "\\Application Data\\Ixui";
        }
        return System.getProperty("user.home") + System.getProperty("file.separator") + ".ixui";
    }

    public static void set(String key, String value) {
        Ini ini = Ini.getInstance();
        try {
            ini.load();
            ini.setProperty(key, value);
            ini.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String get(String key, String defaultValue) {
        Ini ini = Ini.getInstance();
        try {
            ini.load();
            return ini.getProperty(key, defaultValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int get(String key, int defaultValue) {
        Ini ini = Ini.getInstance();
        try {
            ini.load();
            return Integer.valueOf(ini.getProperty(key, String.valueOf(defaultValue)));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static Ini getInstance() {
        try {
            dirname = Ini.getDirname();
            filename = dirname + System.getProperty("file.separator") + ininame;
            dir = new File(dirname);
            file = new File(filename);
        }
        catch (Error e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ini == null) {
            ini = new Ini();
        }
        return ini;
    }

    public void load() throws FileNotFoundException, IOException {
        File f = new File(filename);
        if (f.length() != 0L) {
            p.load(new FileInputStream(filename));
        }
    }

    public void save() throws FileNotFoundException, IOException {
        p.store(new FileOutputStream(filename), "last updated " + new Date());
    }

    public String getProperty(String _name, String _default) {
        if (p.getProperty(_name) == null) {
            return _default;
        }
        return p.getProperty(_name);
    }

    public void setProperty(String _name, String _value) {
        p.setProperty(_name, _value);
    }

    public Set keySet() {
        return p.keySet();
    }

    private Ini() {
        try {
            if (!dir.exists()) {
                dir.mkdir();
            }
            if (!file.exists()) {
                try {
                    File predefined = new File("ixui.ini");
                    if (predefined.exists()) {
                        p.load(new FileInputStream(predefined.getAbsolutePath()));
                    }
                    this.save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(e.getMessage());
                }
            }
        }
        catch (Error e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

