/*
 * Decompiled with CFR 0.152.
 */
package lu.fisch.ixui;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.Desktop;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import lu.fisch.ixui.About;
import lu.fisch.ixui.Ini;
import lu.fisch.ixui.Notice;
import lu.fisch.ixui.Preferences;
import lu.fisch.ixui.lock.JustOneLock;
import lu.fisch.rss.Feed;
import lu.fisch.rss.FeedCategory;
import lu.fisch.rss.FeedEntry;
import lu.fisch.rss.FeedParser;

public class Ixui {
    public static final String VERSION = "2.00-11";
    PopupMenu pop = new PopupMenu();
    TrayIcon trayIcon;
    Timer timer;
    String url;
    String wiki;
    String sound;
    FeedEntry lastForumEntry = null;
    FeedEntry lastWikiEntry = null;

    public static void main(String[] args) {
        JustOneLock ua = new JustOneLock();
        if (ua.isAppActive()) {
            JOptionPane.showMessageDialog(null, "IXUI a d\u00e9j\u00e0 \u00e9t\u00e9 lanc\u00e9!", "IXUI", 0);
        } else {
            Ixui ixui = new Ixui();
        }
    }

    public Ixui() {
        final Ixui ixui = this;
        try {
            String iconFilename = "/lu/fisch/ixui/images/ixus16.png";
            if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
                iconFilename = "/lu/fisch/ixui/images/ixus22bw.png";
            }
            this.trayIcon = new TrayIcon(new ImageIcon(Ixui.class.getResource(iconFilename)).getImage(), "Message IXUS en temps r\u00e9el", this.pop);
            this.trayIcon.setImageAutoSize(true);
            SystemTray.getSystemTray().add(this.trayIcon);
            this.loadPreferences();
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                public void run() {
                    ixui.update();
                }
            }, 0L, 30000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ixui.registerOSX(this.pop);
    }

    public static synchronized void playSound(final URL url) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Clip clip = AudioSystem.getClip();
                    AudioInputStream inputStream = AudioSystem.getAudioInputStream(url);
                    clip.open(inputStream);
                    clip.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
    }

    public void update() {
        Ixui ixui = this;
        Feed feedForum = new FeedParser().parse(this.url);
        Feed feedWiki = new FeedParser().parse(this.wiki);
        if (feedForum.getEntries().size() > 0) {
            if (!feedForum.getEntries().get(0).equals(this.lastForumEntry)) {
                this.buildMenu(feedForum, feedWiki);
                try {
                    Notice notice = new Notice(feedForum.getEntries().get(0).toMenuEntry(), feedForum.getEntries().get(0).getLink());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Ixui.playSound(new URL(this.sound));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.lastForumEntry = feedForum.getEntries().get(0);
        }
    }

    private void addEntryToMenu(Menu component, FeedEntry fe) {
        MenuItem mi = new MenuItem(fe.toMenuEntryAWT());
        final String launchURL = fe.getLink();
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Ixui.launch(launchURL);
            }
        });
        component.add(mi);
    }

    private void buildMenu(Feed forumFeed, Feed wikiFeed) {
        int i;
        this.pop.removeAll();
        for (i = 0; i < forumFeed.getEntries().size(); ++i) {
            this.addEntryToMenu(this.pop, forumFeed.getEntries().get(i));
        }
        this.pop.addSeparator();
        for (i = 0; i < forumFeed.getCategories().size(); ++i) {
            FeedCategory fc = forumFeed.getCategories().get(i);
            Menu mi = new Menu(fc.getName());
            final String launchURL = fc.getUrl();
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Ixui.launch(launchURL);
                }
            });
            for (int j = 0; j < forumFeed.getEntries().size(); ++j) {
                if (forumFeed.getEntries().get(j).getCategory() == null || !forumFeed.getEntries().get(j).getCategory().equals(fc)) continue;
                this.addEntryToMenu(mi, forumFeed.getEntries().get(j));
            }
            this.pop.add(mi);
        }
        try {
            this.pop.addSeparator();
            for (i = 0; i < Math.min(wikiFeed.getEntries().size(), 5); ++i) {
                this.addEntryToMenu(this.pop, wikiFeed.getEntries().get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.appendMenuEnd();
    }

    private void appendMenuEnd() {
        final Ixui ixui = this;
        this.pop.addSeparator();
        MenuItem mi = new MenuItem("Pr\u00e9f\u00e9rences");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Preferences prefs = new Preferences();
                prefs.setVisible(true);
                Ixui.this.loadPreferences();
            }
        });
        this.pop.add(mi);
        mi = new MenuItem("\u00c0 propos");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                About about = new About();
                about.setVisible(true);
            }
        });
        this.pop.add(mi);
        mi = new MenuItem("Quit");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ixui.savePreferences();
                System.exit(0);
            }
        });
        this.pop.add(mi);
    }

    private void savePreferences() {
        try {
            Ini ini = Ini.getInstance();
            ini.load();
            ini.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPreferences() {
        try {
            Ini ini = Ini.getInstance();
            ini.load();
            this.url = ini.getProperty("forumToMonitor", "http://entraide.ixus.net/feed.php");
            this.wiki = ini.getProperty("wikiToMonitor", "http://wiki.ixus.net/feed.php");
            this.sound = ini.getProperty("alertSound", "http://ixui.fisch.lu/Sounds/hit-pipe.wav");
            if (this.sound.startsWith(System.getProperty("file.separator"))) {
                this.sound = "file://" + this.sound;
            }
            ini.setProperty("siteToMonitor", this.url);
            ini.setProperty("alertSound", this.sound);
            ini.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void launch(String filename) {
        System.out.println("open " + filename);
        try {
            Desktop.getDesktop().browse(new URI(filename));
        }
        catch (Exception ex) {
            try {
                Runtime.getRuntime().exec(new String[]{"cmd", "/C", "start", filename});
            }
            catch (IOException e) {
                try {
                    Runtime.getRuntime().exec("open " + filename);
                }
                catch (IOException ex1) {
                    ex1.printStackTrace();
                }
            }
        }
    }

    private void registerOSX(PopupMenu pop) {
        final Ixui ixui = this;
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            System.setProperty("apple.laf.useScreenMenuBar", "false");
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            Application application = Application.getApplication();
            try {
                application.setEnabledPreferencesMenu(true);
                application.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

                    public void handleAbout(ApplicationEvent e) {
                        About about = new About();
                        about.setVisible(true);
                        e.setHandled(true);
                    }

                    public void handleOpenApplication(ApplicationEvent e) {
                    }

                    public void handleOpenFile(ApplicationEvent e) {
                    }

                    public void handlePreferences(ApplicationEvent e) {
                        Preferences prefs = new Preferences();
                        prefs.setVisible(true);
                        Ixui.this.loadPreferences();
                    }

                    public void handlePrintFile(ApplicationEvent e) {
                    }

                    public void handleQuit(ApplicationEvent e) {
                        ixui.savePreferences();
                        System.exit(0);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

