/*
 * Decompiled with CFR 0.152.
 */
package lu.fisch.ixui;

import lu.fisch.utils.StringList;

public class Message {
    private String iconURL;
    private String time;
    private String link;
    private String title;
    private String forum;
    private String user;

    public Message(String iconURL, String time, String link, String title, String forum, String user) {
        this.iconURL = iconURL;
        this.time = time;
        this.link = link;
        this.title = title;
        this.forum = forum;
        this.user = user;
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Message)) {
            return false;
        }
        Message that = (Message)aThat;
        return this.toString().equals(that.toString());
    }

    public String toString() {
        return "[" + this.getTime() + "] " + this.getForum() + " \u2192 " + this.getTitle() + " (" + this.getUser() + ")";
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + (this.getIconURL() != null ? this.getIconURL().hashCode() : 0);
        hash = 17 * hash + (this.getTime() != null ? this.getTime().hashCode() : 0);
        hash = 17 * hash + (this.getLink() != null ? this.getLink().hashCode() : 0);
        hash = 17 * hash + (this.getTitle() != null ? this.getTitle().hashCode() : 0);
        hash = 17 * hash + (this.getForum() != null ? this.getForum().hashCode() : 0);
        hash = 17 * hash + (this.getUser() != null ? this.getUser().hashCode() : 0);
        return hash;
    }

    public String getIconURL() {
        return this.iconURL;
    }

    public String getTime() {
        return this.time;
    }

    public String getLink() {
        StringList linky = StringList.explode(this.link, "#");
        if (linky.count() > 1) {
            return linky.get(0) + "&start=100000#" + linky.get(1);
        }
        return linky.get(0);
    }

    public String getTitle() {
        return this.title;
    }

    public String getForum() {
        return this.forum;
    }

    public String getUser() {
        return this.user;
    }
}

