/*
 * Decompiled with CFR 0.152.
 */
package lu.fisch.ixui.lock;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import lu.fisch.ixui.Ini;

public class JustOneLock {
    private File file;
    private FileChannel channel;
    private FileLock lock;

    public boolean isAppActive() {
        try {
            this.file = new File(Ini.getDirname() + System.getProperty("file.separator") + ".lock");
            this.channel = new RandomAccessFile(this.file, "rw").getChannel();
            try {
                this.lock = this.channel.tryLock();
            }
            catch (OverlappingFileLockException e) {
                this.closeLock();
                return true;
            }
            if (this.lock == null) {
                this.closeLock();
                return true;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    JustOneLock.this.closeLock();
                    JustOneLock.this.deleteFile();
                }
            });
            return false;
        }
        catch (Exception e) {
            this.closeLock();
            return true;
        }
    }

    private void closeLock() {
        try {
            this.lock.release();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteFile() {
        try {
            this.file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

