/*
 * Decompiled with CFR 0.152.
 */
package lu.fisch.rss;

import java.text.SimpleDateFormat;
import java.util.Date;
import lu.fisch.rss.FeedCategory;
import uk.org.catnip.eddie.parser.DateParser;

public class FeedEntry {
    protected String author;
    protected String date;
    protected String id;
    protected String link;
    protected String title;
    protected String content;
    protected FeedCategory category;
    private boolean item = false;

    public FeedEntry() {
        this.author = "";
        this.date = "";
        this.id = "";
        this.link = "";
        this.title = "";
        this.content = "";
        this.category = null;
    }

    public FeedEntry(String author, String date, String id, String link, String title, String content, FeedCategory category) {
        this.author = author;
        this.date = date;
        this.id = id;
        this.link = link;
        this.title = title;
        this.content = content;
        this.category = category;
    }

    public int hashCode() {
        int hash = 5;
        hash = 73 * hash + (this.getAuthor() != null ? this.getAuthor().hashCode() : 0);
        hash = 73 * hash + (this.getDate() != null ? this.getDate().hashCode() : 0);
        hash = 73 * hash + (this.getId() != null ? this.getId().hashCode() : 0);
        hash = 73 * hash + (this.getLink() != null ? this.getLink().hashCode() : 0);
        hash = 73 * hash + (this.getTitle() != null ? this.getTitle().hashCode() : 0);
        hash = 73 * hash + (this.getContent() != null ? this.getContent().hashCode() : 0);
        hash = 73 * hash + (this.getCategory() != null ? this.getCategory().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof FeedEntry)) {
            return false;
        }
        FeedEntry that = (FeedEntry)aThat;
        boolean result = true;
        if (that.getAuthor() == null) {
            result = result && that.getAuthor() == this.getAuthor();
        } else {
            boolean bl = result = result && that.getAuthor().equals(this.getAuthor());
        }
        if (that.getContent() == null) {
            result = result && that.getContent() == this.getContent();
        } else {
            boolean bl = result = result && that.getContent().equals(this.getContent());
        }
        if (that.getDate() == null) {
            result = result && that.getDate() == this.getDate();
        } else {
            boolean bl = result = result && that.getDate().equals(this.getDate());
        }
        if (that.getId() == null) {
            result = result && that.getId() == this.getId();
        } else {
            boolean bl = result = result && that.getId().equals(this.getId());
        }
        if (that.getLink() == null) {
            result = result && that.getLink() == this.getLink();
        } else {
            boolean bl = result = result && that.getLink().equals(this.getLink());
        }
        if (that.getCategory() == null) {
            result = result && that.getCategory() == this.getCategory();
        } else {
            boolean bl = result = result && that.getCategory().equals(this.getCategory());
        }
        result = that.getTitle() == null ? result && that.getTitle() == this.getTitle() : result && that.getTitle().equals(this.getTitle());
        return result;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public FeedCategory getCategory() {
        return this.category;
    }

    public void setCategory(FeedCategory category) {
        this.category = category;
    }

    public Date getJavaDate() {
        return DateParser.parse(this.getDate());
    }

    public String toString() {
        return this.getTitle();
    }

    public String toMenuEntry() {
        if (this.getCategory() == null) {
            return "[" + new SimpleDateFormat("HH:mm").format(this.getJavaDate()) + "] " + this.getTitle() + " (" + this.getAuthor() + ")";
        }
        return "[" + new SimpleDateFormat("HH:mm").format(this.getJavaDate()) + "] " + this.getCategory().getName() + " \u2192 " + this.getTitle() + " (" + this.getAuthor() + ")";
    }

    public String toMenuEntryAWT() {
        String result = new String();
        if (this.getJavaDate() != null) {
            result = result + "[" + new SimpleDateFormat("HH:mm").format(this.getJavaDate()) + "]";
        }
        if (this.getCategory() != null || this.isItem()) {
            result = result + " " + this.getCategory().getName() + " -";
        }
        result = result.trim() + " " + this.getTitle() + " (" + this.getAuthor() + ")";
        return result.trim();
    }

    public boolean isItem() {
        return this.item;
    }

    public void setItem(boolean item) {
        this.item = item;
    }
}

