/*
 * Decompiled with CFR 0.152.
 */
package lu.fisch.rss;

import com.tecnick.htmlutils.htmlentities.HTMLEntities;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import lu.fisch.rss.Feed;
import lu.fisch.rss.FeedCategory;
import lu.fisch.rss.FeedEntry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FeedParser
extends DefaultHandler {
    protected Feed feed;
    protected FeedEntry feedEntry;
    protected boolean inFeedEntry = false;
    protected String data;

    public Feed parse(String _filename) {
        this.feed = new Feed();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(_filename, (DefaultHandler)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.feed;
    }

    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (qualifiedName.equals("entry") || qualifiedName.equals("item")) {
            this.feedEntry = new FeedEntry();
            this.inFeedEntry = true;
        } else if (qualifiedName.equals("link") && this.inFeedEntry) {
            this.feedEntry.setLink(attributes.getValue("href"));
        } else if (qualifiedName.equals("category") && this.inFeedEntry && attributes.getIndex("label") > 0) {
            FeedCategory feedCategory = new FeedCategory(attributes.getValue("label"), attributes.getValue("scheme"));
            this.feedEntry.setCategory(feedCategory);
            this.feed.addCategory(feedCategory);
        }
        this.data = new String();
    }

    public void endElement(String namespaceUri, String localName, String qualifiedName) throws SAXException {
        if (qualifiedName.equals("entry") && this.inFeedEntry) {
            if (this.feedEntry.getTitle() != null && this.feedEntry.getCategory() != null && this.feedEntry.getTitle().startsWith(this.feedEntry.getCategory().getName())) {
                this.feedEntry.setTitle(HTMLEntities.unhtmlQuotes(HTMLEntities.unhtmlentities(this.feedEntry.getTitle().substring(this.feedEntry.getCategory().getName().length() + 2).trim())));
            }
            this.feed.addEntry(this.feedEntry);
            this.inFeedEntry = false;
        } else if (qualifiedName.equals("item") && this.inFeedEntry) {
            this.feedEntry.setItem(true);
            this.feed.addEntry(this.feedEntry);
            this.inFeedEntry = false;
        } else if (qualifiedName.equals("name") && this.inFeedEntry) {
            this.feedEntry.setAuthor(this.data);
        } else if (qualifiedName.equals("author") && this.inFeedEntry) {
            this.feedEntry.setAuthor(this.data);
        } else if (qualifiedName.equals("updated") && this.inFeedEntry) {
            this.feedEntry.setDate(this.data);
        } else if (qualifiedName.equals("pubDate") && this.inFeedEntry) {
            this.feedEntry.setDate(this.data);
        } else if (qualifiedName.equals("id") && this.inFeedEntry) {
            this.feedEntry.setId(this.data);
        } else if (qualifiedName.equals("title") && this.inFeedEntry) {
            this.feedEntry.setTitle(HTMLEntities.unhtmlQuotes(HTMLEntities.unhtmlentities(this.data)));
        } else if (qualifiedName.equals("content") && this.inFeedEntry) {
            this.feedEntry.setContent(this.data);
        } else if (qualifiedName.equals("link") && this.inFeedEntry) {
            if (!this.data.equals("")) {
                this.feedEntry.setLink(this.data);
            }
        } else if (qualifiedName.equals("category") && this.inFeedEntry && !this.data.trim().equals("")) {
            FeedCategory feedCategory = new FeedCategory(this.data, this.feedEntry.getLink());
            this.feedEntry.setCategory(feedCategory);
            this.feed.addCategory(feedCategory);
        }
    }

    public void characters(char[] chars, int startIndex, int length) {
        this.data = this.data + new String(chars, startIndex, length);
    }
}

