/*
 * Decompiled with CFR 0.152.
 */
package lu.fisch.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Vector;
import lu.fisch.utils.BString;

public class StringList {
    private Vector<String> strings = new Vector();
    protected String something;
    final String test = "OK";

    public static StringList getNew(String _string) {
        StringList sl = new StringList();
        sl.add(_string);
        return sl;
    }

    public static StringList explode(String _source, String _by) {
        String[] multi = _source.split(_by);
        StringList sl = new StringList();
        for (int i = 0; i < multi.length; ++i) {
            sl.add(multi[i]);
        }
        return sl;
    }

    public static StringList explode(StringList _source, String _by) {
        StringList sl = new StringList();
        for (int s = 0; s < _source.count(); ++s) {
            String[] multi = _source.get(s).split(_by);
            for (int i = 0; i < multi.length; ++i) {
                sl.add(multi[i]);
            }
        }
        return sl;
    }

    public static StringList explodeWithDelimiter(String _source, String _by) {
        String[] multi = _source.split(_by);
        StringList sl = new StringList();
        for (int i = 0; i < multi.length; ++i) {
            if (i != 0) {
                sl.add(_by);
            }
            sl.add(multi[i]);
        }
        return sl;
    }

    public static StringList explodeWithDelimiter(StringList _source, String _by) {
        StringList sl = new StringList();
        for (int s = 0; s < _source.count(); ++s) {
            StringList multi = BString.explodeWithDelimiter(_source.get(s), _by);
            sl.add(multi);
        }
        return sl;
    }

    public StringList copy() {
        StringList sl = new StringList();
        sl.setCommaText(this.getCommaText() + "");
        return sl;
    }

    public void add(String _string) {
        this.strings.add(_string);
    }

    public void addOrdered(String _string) {
        if (this.count() == 0) {
            this.add(_string);
        } else {
            boolean inserted = false;
            for (int i = 0; i < this.strings.size(); ++i) {
                if (this.strings.get(i).compareTo(_string) <= 0) continue;
                this.strings.insertElementAt(_string, i);
                inserted = true;
                break;
            }
            if (!inserted) {
                this.add(_string);
            }
        }
    }

    public void addByLength(String _string) {
        if (this.count() == 0) {
            this.add(_string);
        } else {
            boolean inserted = false;
            for (int i = 0; i < this.strings.size(); ++i) {
                if (this.strings.get(i).length() >= _string.length()) continue;
                this.strings.insertElementAt(_string, i);
                inserted = true;
                break;
            }
            if (!inserted) {
                this.add(_string);
            }
        }
    }

    public void addIfNew(String _string) {
        if (!this.strings.contains(_string)) {
            this.add(_string);
        }
    }

    public void addOrderedIfNew(String _string) {
        boolean found = false;
        for (int i = 0; i < this.strings.size(); ++i) {
            if (!this.strings.get(i).equals(_string)) continue;
            found = true;
        }
        if (!found) {
            this.addOrdered(_string);
        }
    }

    public void addByLengthIfNew(String _string) {
        boolean found = false;
        for (int i = 0; i < this.strings.size(); ++i) {
            if (!this.strings.get(i).equals(_string)) continue;
            found = true;
        }
        if (!found) {
            this.addByLength(_string);
        }
    }

    public void add(StringList _stringList) {
        for (int i = 0; i < _stringList.count(); ++i) {
            this.strings.add(_stringList.get(i));
        }
    }

    public void addIfNew(StringList _stringList) {
        for (int i = 0; i < _stringList.count(); ++i) {
            if (this.strings.contains(_stringList.get(i))) continue;
            this.strings.add(_stringList.get(i));
        }
    }

    public boolean contains(String _string) {
        boolean found = false;
        for (int i = 0; i < this.strings.size(); ++i) {
            if (!this.strings.get(i).equals(_string)) continue;
            found = true;
        }
        return found;
    }

    public boolean contains(String _string, boolean matchCase) {
        boolean found = false;
        for (int i = 0; i < this.strings.size(); ++i) {
            if (!matchCase) {
                if (!this.strings.get(i).toLowerCase().equals(_string.toLowerCase())) continue;
                found = true;
                continue;
            }
            if (!this.strings.get(i).equals(_string)) continue;
            found = true;
        }
        return found;
    }

    public StringList reverse() {
        StringList sl = new StringList();
        for (int i = 0; i < this.strings.size(); ++i) {
            sl.add(this.get(this.count() - i - 1));
        }
        return sl;
    }

    public void set(int _index, String _s) {
        if (_index < this.strings.size() && _index >= 0) {
            this.strings.remove(_index);
            this.strings.insertElementAt(_s, _index);
        }
    }

    public String get(int _index) {
        if (_index < this.strings.size() && _index >= 0) {
            return this.strings.get(_index);
        }
        return "";
    }

    public void delete(int _index) {
        this.strings.removeElementAt(_index);
    }

    public void insert(String _string, int _index) {
        this.strings.insertElementAt(_string, _index);
    }

    public void setText(String _text) {
        String[] words = _text.split("\n");
        this.strings.clear();
        for (int i = 0; i < words.length; ++i) {
            this.strings.add(words[i]);
        }
    }

    public String getText() {
        String text = new String();
        for (int i = 0; i < this.strings.size(); ++i) {
            text = i == 0 ? this.strings.get(i) : text + "\n" + this.strings.get(i);
        }
        return text;
    }

    public String getLongString() {
        String text = new String();
        for (int i = 0; i < this.strings.size(); ++i) {
            text = i == 0 ? this.strings.get(i) : text + " " + this.strings.get(i);
        }
        return text;
    }

    public int count() {
        return this.strings.size();
    }

    public void setCommaText(String _input) {
        String input = _input + "";
        if (input.length() > 0) {
            String first = Character.toString(input.charAt(0));
            if (!first.equals("\"")) {
                input = "\"" + input;
            }
            if (!(first = Character.toString(input.charAt(input.length() - 1))).equals("\"")) {
                input = input + "\"";
            }
        }
        this.strings.clear();
        String tmp = new String();
        boolean open = false;
        for (int i = 0; i < input.length(); ++i) {
            String chr = Character.toString(input.charAt(i));
            if (chr.equals("\"")) {
                if (i + 1 < input.length()) {
                    if (!open) {
                        open = true;
                        continue;
                    }
                    String next = Character.toString(input.charAt(i + 1));
                    if (next.equals("\"")) {
                        tmp = tmp + "\"";
                        ++i;
                        continue;
                    }
                    if (this.strings.size() != 0 || !tmp.trim().equals("")) {
                        this.strings.add(tmp);
                    }
                    tmp = new String();
                    open = false;
                    continue;
                }
                if (this.strings.size() != 0 || !tmp.trim().equals("")) {
                    this.strings.add(tmp);
                }
                tmp = new String();
                open = false;
                continue;
            }
            if (!open) continue;
            tmp = tmp + chr;
        }
        if (!tmp.trim().equals("")) {
            this.strings.add(tmp);
        }
    }

    public String getCommaText() {
        String res = new String();
        for (int i = 0; i < this.strings.size(); ++i) {
            res = i == 0 ? res + "\"" + BString.replace(this.get(i), "\"", "\"\"") + "\"" : res + ",\"" + BString.replace(this.get(i), "\"", "\"\"") + "\"";
        }
        return res;
    }

    public void loadFromURL(String url) {
        try {
            this.strings.clear();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
            String line = reader.readLine();
            while (line != null) {
                this.add(line);
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadFromFile(String _filename) {
        try {
            int ch;
            StringBuffer buffer = new StringBuffer();
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(new File(_filename)), "UTF-8");
            BufferedReader in = new BufferedReader(isr);
            while ((ch = ((Reader)in).read()) > -1) {
                buffer.append((char)ch);
            }
            ((Reader)in).close();
            this.strings.clear();
            this.add(StringList.explode(buffer.toString(), "\n"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveToFile(String _filename) {
        try {
            FileOutputStream fos = new FileOutputStream(_filename);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            out.write(this.getText());
            ((Writer)out).close();
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public String copyFrom(int beginLine, int beginIndex, int endLine, int endIndex) {
        String ret = "";
        for (int i = beginLine; i <= endLine; ++i) {
            String line = this.get(i);
            if (i == beginLine) {
                if (line.length() <= beginIndex || beginIndex < 0) continue;
                ret = ret + line.substring(beginIndex);
                continue;
            }
            ret = i == endLine ? ret + "\n" + line.substring(0, Math.min(endIndex, line.length())) : ret + "\n" + line;
        }
        return ret;
    }

    public String toString() {
        return this.getCommaText();
    }

    public void removeDoubleEmptyLines() {
        for (int i = this.strings.size() - 2; i >= 0; --i) {
            if (!this.strings.get(i).trim().equals("") || !this.strings.get(i + 1).trim().equals("")) continue;
            this.strings.remove(i + 1);
        }
    }
}

